#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//PaisleyMod01.fsh   by  yasuo
//https://www.shadertoy.com/view/wldcRn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define Rot(a) mat2(cos(a),-sin(a),sin(a),cos(a))
#define antialiasing(n) n/min(iResolution.y,iResolution.x)
#define S(d,b) smoothstep(antialiasing(1.0),b,d)
#define BASE_COLOR vec3(0.3,0.6,0.3)

vec2 bend(vec2 p, float k){
    float c = cos(k*p.y);
    float s = sin(k*p.y);
    mat2  m = mat2(c,-s,s,c);
    vec2  q = p*m;
    return q;
}

// https://iquilezles.org/articles/distfunctions2d
float sdVesica(vec2 p, float r, float d)
{
    p = abs(p);
    float b = sqrt(r*r-d*d);
    return ((p.y-b)*d>p.x*b) ? length(p-vec2(0.0,b))
                             : length(p-vec2(-d,0.0))-r;
}

// https://iquilezles.org/articles/distfunctions2d
float sdUnevenCapsule( vec2 p, float r1, float r2, float h )
{
    p.x = abs(p.x);
    float b = (r1-r2)/h;
    float a = sqrt(1.0-b*b);
    float k = dot(p,vec2(-b,a));
    if( k < 0.0 ) return length(p) - r1;
    if( k > a*h ) return length(p-vec2(0.0,h)) - r2;
    return dot(p, vec2(a,b) ) - r1;
}

float paiselyDist(vec2 p, float sy, float scale) {
    vec2  q = bend(p,1.5);

    q.y*=sy*scale;
    q*=0.8*scale;
    float d = sdUnevenCapsule(q,0.15,0.02*scale,0.35*scale);
    return d;
}

vec3 paiselyTex(vec2 p, vec3 col, float dir, float t) {
    p*=Rot(radians(t*30.0*dir));
    p*=1.2;
    vec2 prevP = p;
    p = abs(p);
    p -= vec2(0.05,0.05);
    float d = abs(sdVesica(p*Rot(radians(45.0)),0.1,0.07))-0.005;
    col = mix(col,BASE_COLOR,S(d,0.0));
    
    p = prevP;
    
    p *= Rot(radians(45.0));
    p = abs(p);
    p -= vec2(0.05,0.05);
    d = abs(sdVesica(p*Rot(radians(45.0)),0.1,0.07))-0.005;
    col = mix(col,BASE_COLOR,S(d,0.0));
    
    return col;
}

vec3 paisely(vec2 p, vec3 col, float t) {
    vec3 baseCol = BASE_COLOR;
    vec2 pos = vec2(0.0,-0.1);
    vec2 prevP = p;
    float d = abs(paiselyDist(p-pos,0.9,0.88))-0.002;
    float d2 = abs(paiselyDist(p-pos,0.87,1.05))-0.001;
    float d3 = abs(paiselyDist(p-pos,0.85,1.25))-0.003;
    float d4 = abs(paiselyDist(p-pos,0.9,0.82))-0.001;
    col = mix(col,baseCol,S(d,0.0));
    col = mix(col,baseCol*1.2,S(d2,0.0));
    col = mix(col,baseCol,S(d3,0.0));
    col = mix(col,baseCol,S(d4,0.0));
    
    p*=3.2;
    col = paiselyTex(p-vec2(0.4,0.55),col,1.0,t);
    
    p = prevP;
    p*=1.8;
    col = paiselyTex(p-vec2(0.11,0.15),col,-1.0,t);
    
    p = prevP;
    col = paiselyTex(p-vec2(0.01,-0.11),col,1.0,t);
    
    p = prevP;
    p*=3.5;
    col = paiselyTex(p-vec2(-0.13,0.13),col,1.0,t);
    
    p = prevP;
    p*=2.8;
    col = paiselyTex(p-vec2(0.1,-0.82),col,-1.0,t);
    
    p = prevP;
    p*=3.2;
    col = paiselyTex(p-vec2(-0.2,-0.89),col,1.0,t);
    
    p = prevP;
    p*=3.2;
    col = paiselyTex(p-vec2(0.4,-0.78),col,1.0,t);
        
    p = prevP;
    p*=4.2;
    col = paiselyTex(p-vec2(1.15,1.25),col,1.0,t);
    
    p = prevP;
    
    p.x -=0.01;
    p.x = abs(p.x);
    p.x -= 0.15;
    d = length(p-vec2(0.01,0.0))-0.02;
    col = mix(col,baseCol,S(d,0.0));
    
    p = prevP;
    p.x = abs(p.x);
    p.x -= 0.18;
    d = length(p-vec2(0.0,-0.12))-0.02;
    col = mix(col,baseCol,S(d,0.0));
    
    p = prevP;
    d = length(p-vec2(-0.14,-0.22))-0.02;
    col = mix(col,baseCol,S(d,0.0));
    
    d = length(p-vec2(-0.072,0.11))-0.02;
    col = mix(col,baseCol,S(d,0.0));
    
    d = length(p-vec2(0.063,0.215))-0.013;
    col = mix(col,baseCol,S(d,0.0));
        
    d = length(p-vec2(0.187,0.13))-0.017;
    col = mix(col,baseCol,S(d,0.0));
    
    return col;
}

vec3 renderTexture(vec2 p, vec3 col, float t) {
    p*=1.3;
    
    vec2 prevP = p;
    
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    col = paisely(p,col,t);
    p = prevP;
        
    p.y+=0.1;
    p.x+=0.475;
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    
    p*=1.2;
    col = paisely(p*Rot(radians(-180.0)),col,t);
    p = prevP;
    
    p.x+=0.3;
    p.y+=-0.35;
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    p*=1.8;
    col = paisely(p*Rot(radians(120.0)),col,t);
    p = prevP;
    
    p.x+=0.08;
    p.y+=-0.31;
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    p*=1.2;
    col = paiselyTex(p,col,1.0,t);
    p = prevP;
        
    p.x+=0.28;
    p.y+=-0.57;
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    p*=1.8;
    col = paiselyTex(p,col,-1.0,t);
    p = prevP;
            
    p.x+=0.56;
    p.y+=-0.3;
    p.x = mod(p.x,1.0)-0.5;
    p.y = mod(p.y,0.8)-0.4;
    p*=2.1;
    col = paiselyTex(p,col,1.0,t);
    
    return  col;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    float t = iTime*0.1;
    
    uv.y+=t;
    
    vec2 prevUV = uv;
    vec3 col = vec3(0.99,0.98,0.95);

    float t2 = mod(iTime,8000.0);
    col = renderTexture(uv,col,t2);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

